/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.ui.layout.values;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.betterx.ui.layout.values.Size;

@Environment(value=EnvType.CLIENT)
public class Rectangle {
    public static final Rectangle ZERO = new Rectangle(0, 0, 0, 0);
    public final int left;
    public final int top;
    public final int width;
    public final int height;

    public Rectangle(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public float aspect() {
        return (float)this.width / (float)this.height;
    }

    public Size sizeFromWidth(int width) {
        return new Size(width, (int)((float)width / this.aspect()));
    }

    public Size sizeFromHeight(int height) {
        return new Size((int)((float)height * this.aspect()), height);
    }

    public Size size(float scale) {
        return new Size((int)((float)this.width * scale), (int)((float)this.height * scale));
    }

    public Size size() {
        return new Size(this.width, this.height);
    }

    public int right() {
        return this.left + this.width;
    }

    public int bottom() {
        return this.top + this.height;
    }

    public Rectangle movedBy(int left, int top) {
        return new Rectangle(this.left + left, this.top + top, this.width, this.height);
    }

    public Rectangle movedBy(int left, int top, int deltaWidth, int deltaHeight) {
        return new Rectangle(this.left + left, this.top + top, this.width + deltaWidth, this.height + deltaHeight);
    }

    public boolean overlaps(Rectangle r) {
        return this.left < r.right() && this.right() > r.left && this.top < r.bottom() && this.bottom() > r.top;
    }

    public boolean contains(int x, int y) {
        return x >= this.left && x <= this.right() && y >= this.top && y <= this.bottom();
    }

    public boolean contains(double x, double y) {
        return x >= (double)this.left && x <= (double)this.right() && y >= (double)this.top && y <= (double)this.bottom();
    }

    public Rectangle intersect(Rectangle r) {
        if (!this.overlaps(r)) {
            return ZERO;
        }
        int left = Math.max(this.left, r.left);
        int top = Math.max(this.top, r.top);
        int right = Math.min(this.right(), r.right());
        int bottom = Math.min(this.bottom(), r.bottom());
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public String toString() {
        return "rectangle{" + this.left + "x" + this.top + ", " + this.right() + "x" + this.bottom() + " [" + this.width + "x" + this.height + "]}";
    }
}

